#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//  Cut glassMod01.fsh    by    ChunderFPV  
//https://www.shadertoy.com/view/ddBXDm
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define H(a) (cos(radians(vec3(90, 30, -30))-((a)*6.2832))*.5+.5)  // hue pallete
#define RT(a) mat2(cos(m.a*1.571+vec4(0,-1.571,1.571,0)))          // rotate
float cubes(vec3 p) { p = abs(p-round(p)); return max(p.x, max(p.y, p.z)); }
#define C  fragColor
#define U  fragCoord

//void mainImage( out vec4 C, in vec2 U ){
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    float aa = 2., // anti-aliasing (1 = off)
          d, s;
    vec2 R = iResolution.xy,
         m = (iMouse.xy/R*4.)-2.,
         o;
    vec3 c = vec3(0), // black background
         cam = vec3(vec2(.5), iTime/4.),
         u, v;
    if (iMouse.z < 1.) m = vec2(cos(iTime/8.)*.5+.5); // rotate with time
    mat2 pitch = RT(y), 
         yaw   = RT(x);
    for (int k = 0; k < int(aa*aa); k++) // aa loop
    {
        o = vec2(k%2, k/2)/aa; // aa offset
        u = normalize(vec3((U-.5*R+o)/R.y, .7));
        u.yz *= pitch;
        u.xz *= yaw;
        d = 0.; // step dist for raymarch
        for (int i = 0; i < 50; i++) // raymarch loop
        {
            s = smoothstep(.2, .25, cubes(cam+u*d)-.05);
            if (s < 0.01) break;
            d += s;
        }
        v = d*.01*H(length(u.xy)); // objects & color
        c += v + max(v, .5-H(d));  // add to bg
    }
    c /= aa*aa;
    fragColor = vec4(exp(log(c)/2.2), 1);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

